<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class InvitationRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'email' => ['required', 'email'],
            'role' => ['required', Rule::in(['admin', 'editor', 'readonly'])],
            'expires_at' => ['required', 'date', 'after:now'],
        ];
    }

    public function messages(): array
    {
        return [
            'email.required' => 'Please enter an email address.',
            'email.email' => 'Please enter a valid email address.',
            'role.required' => 'Please select a role.',
            'role.in' => 'Please select a valid role.',
            'expires_at.required' => 'Please select an expiration date.',
            'expires_at.after' => 'The expiration date must be in the future.',
        ];
    }
} 