<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('organizations', function (Blueprint $table) {
            // Organization Details
            $table->string('organization_type')->nullable();
            $table->string('industries')->nullable();
            $table->string('employee_count_range')->nullable();
            $table->string('region')->nullable();
            $table->string('timezone')->nullable();
            
            // AWS Details
            $table->string('primary_aws_region')->nullable();
            $table->json('compliance_requirements')->nullable();
            $table->string('aws_org_role')->nullable();
            
            // Additional Features
            $table->json('tags')->nullable();
            $table->string('onboarding_goal')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('organizations', function (Blueprint $table) {
            $table->dropColumn([
                'organization_type',
                'industries',
                'employee_count_range',
                'region',
                'timezone',
                'primary_aws_region',
                'compliance_requirements',
                'aws_org_role',
                'tags',
                'onboarding_goal',
            ]);
        });
    }
}; 