export const ORGANIZATION_TYPES = {
  enterprise: 'Enterprise',
  startup: 'Startup',
  educational: 'Educational Institution',
  government: 'Government',
  non_profit: 'Non-Profit',
}

export const EMPLOYEE_RANGES = {
  '1-10': '1-10 employees',
  '11-50': '11-50 employees',
  '51-200': '51-200 employees',
  '201-500': '201-500 employees',
  '501-1000': '501-1000 employees',
  '1001-5000': '1001-5000 employees',
  '5000+': '5000+ employees',
}

export const AWS_ORG_ROLES = {
  admin: 'Administrator',
  member: 'Member',
  none: 'Not Part of AWS Organization',
}

export const INDUSTRIES = {
  technology: 'Technology',
  healthcare: 'Healthcare',
  finance: 'Finance',
  education: 'Education',
  retail: 'Retail',
  manufacturing: 'Manufacturing',
  government: 'Government',
  non_profit: 'Non-Profit',
  other: 'Other',
}

export const AWS_REGIONS = {
  'us-east-1': 'US East (N. Virginia)',
  'us-east-2': 'US East (Ohio)',
  'us-west-1': 'US West (N. California)',
  'us-west-2': 'US West (Oregon)',
  'eu-west-1': 'EU (Ireland)',
  'eu-central-1': 'EU (Frankfurt)',
  'ap-southeast-1': 'Asia Pacific (Singapore)',
  'ap-southeast-2': 'Asia Pacific (Sydney)',
  'ap-northeast-1': 'Asia Pacific (Tokyo)',
}

export const ONBOARDING_GOALS = {
  security_monitoring: 'Security Monitoring',
  compliance_audit: 'Compliance Audit',
  cost_optimization: 'Cost Optimization',
  performance_monitoring: 'Performance Monitoring',
  incident_response: 'Incident Response',
  other: 'Other',
}

// Common timezone options
export const TIMEZONES = {
  'UTC': 'UTC',
  'America/New_York': 'Eastern Time',
  'America/Chicago': 'Central Time',
  'America/Denver': 'Mountain Time',
  'America/Los_Angeles': 'Pacific Time',
  'America/Anchorage': 'Alaska Time',
  'Pacific/Honolulu': 'Hawaii Time',
  'Europe/London': 'London',
  'Europe/Paris': 'Paris',
  'Europe/Berlin': 'Berlin',
  'Asia/Dubai': 'Dubai',
  'Asia/Shanghai': 'Shanghai',
  'Asia/Tokyo': 'Tokyo',
  'Australia/Sydney': 'Sydney',
}

export const REGIONS = {
  'north_america': {
    label: 'North America',
    standards: ['SOX', 'HIPAA', 'PCI DSS', 'NIST', 'FedRAMP'],
    description: 'United States and Canada',
  },
  'europe': {
    label: 'Europe',
    standards: ['GDPR', 'PCI DSS', 'ISO 27001', 'NIS Directive', 'eIDAS'],
    description: 'European Union and United Kingdom',
  },
  'asia_pacific': {
    label: 'Asia Pacific',
    standards: ['PDPA', 'ISO 27001', 'PCI DSS', 'APEC Privacy Framework'],
    description: 'Asia Pacific Region',
  },
  'middle_east': {
    label: 'Middle East',
    standards: ['SAMA', 'NESA', 'PCI DSS', 'ISO 27001'],
    description: 'Middle East Region',
  },
  'latin_america': {
    label: 'Latin America',
    standards: ['LGPD', 'PCI DSS', 'ISO 27001'],
    description: 'Central and South America',
  },
  'africa': {
    label: 'Africa',
    standards: ['POPIA', 'PCI DSS', 'ISO 27001'],
    description: 'African Continent',
  },
  'australia_nz': {
    label: 'Australia & New Zealand',
    standards: ['Privacy Act', 'APRA', 'PCI DSS', 'ISO 27001'],
    description: 'Australia and New Zealand',
  },
}

// For use in dropdowns where we just need key-value pairs
export const REGION_OPTIONS = Object.entries(REGIONS).reduce((acc, [key, value]) => {
  acc[key] = value.label
  return acc
}, {})

// Comprehensive list of compliance standards
export const COMPLIANCE_STANDARDS = {
  'hipaa': {
    name: 'HIPAA',
    description: 'Health Insurance Portability and Accountability Act',
    category: 'Healthcare',
    regions: ['north_america'],
  },
  'gdpr': {
    name: 'GDPR',
    description: 'General Data Protection Regulation',
    category: 'Data Protection',
    regions: ['europe'],
  },
  'pci_dss': {
    name: 'PCI DSS',
    description: 'Payment Card Industry Data Security Standard',
    category: 'Payment Security',
    regions: ['global'],
  },
  'sox': {
    name: 'SOX',
    description: 'Sarbanes-Oxley Act',
    category: 'Financial',
    regions: ['north_america'],
  },
  'iso_27001': {
    name: 'ISO 27001',
    description: 'Information Security Management System Standard',
    category: 'Information Security',
    regions: ['global'],
  },
  'nist': {
    name: 'NIST',
    description: 'National Institute of Standards and Technology',
    category: 'Security Framework',
    regions: ['north_america'],
  },
  'fedramp': {
    name: 'FedRAMP',
    description: 'Federal Risk and Authorization Management Program',
    category: 'Government',
    regions: ['north_america'],
  },
  'ccpa': {
    name: 'CCPA',
    description: 'California Consumer Privacy Act',
    category: 'Data Protection',
    regions: ['north_america'],
  },
  'lgpd': {
    name: 'LGPD',
    description: 'Lei Geral de Proteção de Dados',
    category: 'Data Protection',
    regions: ['latin_america'],
  },
  'pdpa': {
    name: 'PDPA',
    description: 'Personal Data Protection Act',
    category: 'Data Protection',
    regions: ['asia_pacific'],
  },
}

// Security requirement categories that will be suggested based on region and industry
export const SECURITY_REQUIREMENTS = {
  'data_encryption': {
    name: 'Data Encryption',
    description: 'Requirements for encrypting data at rest and in transit',
    applicableStandards: ['hipaa', 'gdpr', 'pci_dss'],
  },
  'access_control': {
    name: 'Access Control',
    description: 'Identity and access management requirements',
    applicableStandards: ['iso_27001', 'nist', 'fedramp'],
  },
  'incident_response': {
    name: 'Incident Response',
    description: 'Security incident handling and response procedures',
    applicableStandards: ['hipaa', 'gdpr', 'iso_27001'],
  },
  'audit_logging': {
    name: 'Audit Logging',
    description: 'Requirements for logging and monitoring',
    applicableStandards: ['pci_dss', 'sox', 'iso_27001'],
  },
  'vulnerability_management': {
    name: 'Vulnerability Management',
    description: 'Requirements for identifying and managing vulnerabilities',
    applicableStandards: ['nist', 'iso_27001', 'fedramp'],
  },
  'business_continuity': {
    name: 'Business Continuity',
    description: 'Disaster recovery and business continuity requirements',
    applicableStandards: ['iso_27001', 'fedramp'],
  },
} 