@component('mail::message')
# You've Been Invited

You have been invited to join **{{ $invitation->organization->name }}** as a {{ $invitation->role }}.

This invitation was sent by {{ $invitation->inviter->name }} and will expire on {{ $expiresAt }}.

@component('mail::panel')
As a {{ $invitation->role }}, you will be able to:
@if($invitation->role === 'admin')
- View and manage all organization data
- Manage organization settings
- Invite and manage members
@elseif($invitation->role === 'editor')
- View and edit organization data
- Access organization resources
@else
- View organization data
- Access basic resources
@endif
@endcomponent

@component('mail::button', ['url' => route('invitations.accept', $invitation->token), 'color' => 'success'])
Accept Invitation
@endcomponent

@component('mail::button', ['url' => route('invitations.decline', $invitation->token), 'color' => 'error'])
Decline Invitation
@endcomponent

If you did not expect this invitation, you can safely ignore this email.

Thanks,<br>
{{ config('app.name') }}

<x-mail::subcopy>
This invitation will expire on {{ $expiresAt }}. If you need a new invitation after it expires, please contact the sender.
</x-mail::subcopy>
@endcomponent 